using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var P = new (long x, long y)[N];

        for (int i = 0; i < N; i++)
        {
            var s = Console.ReadLine().Split();
            P[i] = (long.Parse(s[0]), long.Parse(s[1]));
        }

        long ANS = 0;

        ANS += COUNT(P, p => p.x + p.y);
        ANS += COUNT(P, p => p.x - p.y);

        Console.WriteLine(ANS);
    }

    static long COUNT((long x, long y)[] P, Func<(long x, long y), long> KEY)
    {
        var G = new Dictionary<long, List<(long x, long y)>>();

        foreach (var p in P)
        {
            long k = KEY(p);
            if (!G.ContainsKey(k)) G[k] = new List<(long, long)>();
            G[k].Add(p);
        }

        long RES = 0;

        foreach (var g in G.Values)
        {
            g.Sort((a, b) => a.x.CompareTo(b.x));

            var Y = g.Select(p => p.y).ToArray();
            RES += INV_COUNT(Y);
        }

        return RES;
    }

    static long INV_COUNT(long[] A)
    {
        var B = A.Distinct().OrderBy(x => x).ToArray();
        var IDX = new Dictionary<long, int>();
        for (int i = 0; i < B.Length; i++) IDX[B[i]] = i + 1;

        int M = B.Length;
        long[] BIT = new long[M + 2];

        long RES = 0;

        for (int i = A.Length - 1; i >= 0; i--)
        {
            int p = IDX[A[i]];
            RES += QUERY(BIT, p - 1);
            UPDATE(BIT, p, 1);
        }

        return RES;
    }

    static void UPDATE(long[] BIT, int i, long v)
    {
        while (i < BIT.Length)
        {
            BIT[i] += v;
            i += i & -i;
        }
    }

    static long QUERY(long[] BIT, int i)
    {
        long s = 0;
        while (i > 0)
        {
            s += BIT[i];
            i -= i & -i;
        }
        return s;
    }
}